document.addEventListener("DOMContentLoaded", () => {
  const buttons = document.querySelectorAll(".letter-btn");
  const popup = document.getElementById("letterpopup");
  const popupLetter = document.getElementById("popup-letter");
  const popupWord = document.getElementById("popup-word");
  const popupImage = document.getElementById("popup-image");
  const closeButton = document.querySelector(".close");

 // START OF CODE:  https://gist.github.com/Ademking/560d541e87043bfff0eb8470d3ef4894
  const colors = [
    "#FF5733", "#33FF57", "#3357FF", "#FF33A8", "#A833FF", "#FFD700", "#00FFFF",
    "#FF4500", "#8A2BE2", "#20B2AA"
  ];
  // END CODE

  
// START CODE: https://www.w3schools.com/howto/howto_js_toggle_dark_mode.asp
  let isDarkMode = document.body.classList.contains("dark-mode");

  const toggleButton = document.getElementById("dark-mode-toggle");
  
 
  toggleButton.textContent = isDarkMode ? "Light Mode" : "Dark Mode";

  
  function adjustColorForDarkMode(color, isDarkMode) {
    if (!isDarkMode) return color; 
    return shadeColor(color, -40); 
  }

  // END CODE:

  
  buttons.forEach((button, index) => {
    const baseColor = colors[index % colors.length];
    const adjustedColor = adjustColorForDarkMode(baseColor, isDarkMode);
    const hoverColor = shadeColor(adjustedColor, -20);

    button.style.backgroundColor = adjustedColor;

    button.addEventListener("mouseover", () => {
      button.style.backgroundColor = hoverColor;
    });

    button.addEventListener("mouseout", () => {
      button.style.backgroundColor = adjustedColor;
    });

    button.addEventListener("click", () => {
      const letter = button.getAttribute("data-letter");
      const word = button.getAttribute("data-word");
      const imgSrc = button.getAttribute("data-img");

      popupLetter.textContent = letter;
      popupWord.textContent = word;
      popupImage.src = imgSrc;
      popupImage.alt = word;
      popup.style.display = "block";
    });
  });

  closeButton.addEventListener("click", () => {
    popup.style.display = "none";
  });

  window.addEventListener("click", (event) => {
    if (event.target === popup) {
      popup.style.display = "none";
    }
  });

  toggleButton.addEventListener("click", () => {
    document.body.classList.toggle("dark-mode");
    isDarkMode = document.body.classList.contains("dark-mode");

    toggleButton.textContent = isDarkMode ? "Light Mode" : "Dark Mode";

    buttons.forEach((button, index) => {
      const baseColor = colors[index % colors.length];
      const adjustedColor = adjustColorForDarkMode(baseColor, isDarkMode);
      const hoverColor = shadeColor(adjustedColor, -20);

      button.style.backgroundColor = adjustedColor;

      button.addEventListener("mouseover", () => {
        button.style.backgroundColor = hoverColor;
      });

      button.addEventListener("mouseout", () => {
        button.style.backgroundColor = adjustedColor;
      });
    });
  });
});

 // START OF CODE: https://gist.github.com/thgh/7f63a2253c2ad3d6972a196b919b2481
function shadeColor(color, percent) {
  let R = parseInt(color.substring(1, 3), 16);
  let G = parseInt(color.substring(3, 5), 16);
  let B = parseInt(color.substring(5, 7), 16);

  R = parseInt((R * (100 + percent)) / 100);
  G = parseInt((G * (100 + percent)) / 100);
  B = parseInt((B * (100 + percent)) / 100);

  R = R < 255 ? R : 255;
  G = G < 255 ? G : 255;
  B = B < 255 ? B : 255;

  const RR = R.toString(16).padStart(2, "0");
  const GG = G.toString(16).padStart(2, "0");
  const BB = B.toString(16).padStart(2, "0");

  return `#${RR}${GG}${BB}`;

  // End OF CODE: 
}
